<!doctype html>

<html lang="pt-br">

<head>
    <style>
        *{
            --backgroud-header: {{$portal->headercor}};
            --backgroud-footer: {{$portal->footercor}};
            --text-header: {{$portal->headertextcor}};
            --text-footer: {{$portal->footertextcor}};



        }
    </style>
    @yield('header')

</head>




<body data-spy="scroll" data-target=".site-navbar-target" data-offset="300">

<div id="overlayer"></div>



<!-- LOADER -->

<div class="loader">

    <div class="spinner-border text-primary" role="status">
        <span class="sr-only">Carregando...</span>
    </div>

</div>

<!-- FECHA LOADER -->



<div class="site-wrap" id="home-section">

    <div class="site-mobile-menu site-navbar-target">

        <div class="site-mobile-menu-header">

            <div class="site-mobile-menu-close mt-3">

                <span class="icon-close2 js-menu-toggle"></span>

            </div>

        </div>

        <div class="site-mobile-menu-body"></div>

    </div>



    <!-- BARRA DE ACESSIBILIDADE -->

    <div class="accessibility-bar" style="background-color: {{$portal->headercor}};">

        <div class="container">

            <!--<a href="#main" class="skip">Skip To Content</a>  -->
            <span class="frase">Acessibilidade</span>
            <button class="increase"><span class="fas fa-plus"></span></button>
            <button class="decrease"><span class="fas fa-minus"></span></button>
            <button class="contrast"><span class="fas fa-adjust"></span></button>

        </div>

    </div>

    <!-- FECHA BARRA DE ACESSIBILIDADE -->



    <!-- MENU -->

    <header class="site-navbar js-sticky-header " role="banner">

        <div class="container">

            <div class="row align-items-center position-relative">

                <div class="site-logo" id="logook">
                    <a href="{{routeTenant('site.transparencia.index')}}"><img src="{{asset($portal->imglogo)}}" style="max-height:90px; " ></a>
                </div>

                <h3 class="nome">Portal da <br> Transparência</h3>


                <div class="col-12">

                    <nav class="site-navigation text-right ml-auto " role="navigation">

                        <ul class="site-menu main-menu js-clone-nav ml-auto d-none d-lg-block">


                            @yield('menu')

                            <li class="has-children">
                                <a href="" class="nav-link">Transparência</a>
                                <ul class="dropdown arrow-top">
                                    @if($portal->trasparencia_receita == 1)
                                    <li><a href="{{routeTenant('site.transparencia.receitas')}}" class="nav-link">Receitas</a></li>
                                    @endif
                                    @if($portal->trasparencia_despesa == 1)
                                    <li><a href="{{routeTenant('site.transparencia.despesas')}}" class="nav-link">Despesas</a></li>
                                        @endif
                                        @if($portal->trasparencia_licitacao == 1)
                                    <li><a href="{{routeTenant('site.transparencia.licitacoes')}}" class="nav-link">Licitações</a></li>
                                        @endif
                                        @if($portal->trasparencia_contratos == 1)
                                    <li><a href="{{routeTenant('site.transparencia.contratos')}}" class="nav-link">Contratos</a></li>
                                        @endif
                                        @if($portal->trasparencia_diarias == 1)
                                    <li><a href="{{routeTenant('site.transparencia.diarias')}}" class="nav-link">Diárias de Viagens</a></li>
                                        @endif
                                        @if($portal->trasparencia_servidores == 1)
                                    <li><a href="{{routeTenant('site.transparencia.servidores')}}" class="nav-link">Servidores Públicos</a></li>
                                        @endif
                                        @if($portal->trasparencia_legislacao == 1)
                                    <li><a href="#" class="nav-link">Legislação</a></li>
                                        @endif
                                        @if($portal->trasparencia_convenios == 1)
                                    <li><a href="#" class="nav-link">Convênios</a></li>
                                        @endif
                                        @if($portal->trasparencia_gestao == 1)
                                    <li><a href="#" class="nav-link">Gestão</a></li>
                                        @endif

                                </ul>
                            </li>

                            <li><a href="{{routeTenant('site.ouvidoria')}}" class="nav-link">Ouvidoria</a></li>
                            <!--<li><a href="#contact-section" class="nav-link">Contato</a></li>-->

                        </ul>

                    </nav>

                </div>

                <div class="toggle-button d-inline-block d-lg-none"><a href="#" class="site-menu-toggle py-5 js-menu-toggle text-black"><span class="icon-menu h3"></span></a></div>

            </div>

        </div>

    </header>

    <!-- FECHA MENU -->

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (session('success'))

        <div class="alert alert-success">
            {{ session('success') }}
        </div>

    @endif
    @if (session('erro'))

        <div class="alert alert-danger">
            {{ session('erro') }}
        </div>

@endif


@yield('content')



<!-- FOOTER -->

<div class="novo-footer">

    <footer id="footer" class="bg-light">

        <div id="top-footer" class="section sm-section">

            <div class="container">

                <div class="row">

                    <div class="col-md-4 footer-widget">

                        <div class="footer-logo">

                            <a class="logo" href="{{routeTenant('site.transparencia.index')}}">
                                <img src="{{asset($portal->imglogo)}}"alt="logo">
                            </a>

                            <!--<p>Gestão</p>-->

                        </div>

                        <ul class="footer-contact">

                            <li><i class="fa fa-map" style="color: orange; margin-right: 8px;"></i><span> {{$portal->endereco}} - CEP: {{$portal->cep}}<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{$portal->cidade}}</span></li>
                            <li><i class="fa fa-phone" style="color: orange; margin-right: 8px;"></i><span> {{$portal->telefone}}</span></li>
                            <li><i class="fa fa-envelope" style="color: orange; margin-right: 8px;"></i><span> {{$portal->email}}</span></li>

                        </ul>

                    </div>


                    <div class="col-md-4 footer-widget">

                        <div class="row">

                            <div class="col-md-12">
                                <h3>Transparência</h3>
                            </div>

                            <div class="col-md-6 col-xs-6">

                                <ul class="footer-links">
                                    @if($portal->trasparencia_receita == 1)
                                    <li><a href="{{routeTenant('site.transparencia.receitas')}}">Receitas</a></li>
                                    @endif
                                    @if($portal->trasparencia_despesa == 1)
                                    <li><a href="{{routeTenant('site.transparencia.despesas')}}">Despesas</a></li>
                                        @endif
                                        @if($portal->trasparencia_licitacao == 1)
                                    <li><a href="{{routeTenant('site.transparencia.licitacoes')}}">Licitações</a></li>
                                        @endif
                                        @if($portal->trasparencia_contratos == 1)
                                    <li><a href="{{routeTenant('site.transparencia.contratos')}}">Contratos</a></li>
                                        @endif
                                        @if($portal->trasparencia_diarias == 1)
                                    <li><a href="{{routeTenant('site.transparencia.diarias')}}">Diárias de viagens</a></li>
                                        @endif


                                </ul>

                            </div>

                            <div class="col-md-6 col-xs-6">

                                <ul class="footer-links">

                                    @if($portal->trasparencia_servidores == 1)
                                    <li><a href="#">Servidores</a></li>
                                    @endif
                                    @if($portal->trasparencia_legislacao == 1)
                                    <li><a href="#">Legislação</a></li>
                                        @endif
                                        @if($portal->trasparencia_convenios == 1)
                                    <li><a href="#">Convênios</a></li>
                                        @endif
                                        @if($portal->trasparencia_gestao == 1)
                                    <li><a href="#">Gestão</a></li>
                                        @endif


                                </ul>

                            </div>

                        </div>

                    </div>


                    <div class="col-md-4 footer-widget">

                        <h3>Fique por dentro</h3>

                        <p>Inscreva-se para receber nossas novidades em primeira mão.</p>

                        <div class="footer-subscribe">

                            <form>
                                <input class="input" type="email" placeholder="Seu e-mail">
                                <button>Inscrever-se</button>
                            </form>

                        </div>

                        <ul class="footer-social">
                            <li><a href="#"><i class="fa fa-facebook"></i></a></li>
                            <li><a href="#"><i class="fa fa-twitter"></i></a></li>
                            <li><a href="#"><i class="fa fa-instagram"></i></a></li>
                        </ul>

                    </div>

                </div>

            </div>

        </div>


        <div id="bottom-footer" class="section xs-section text-center">

            <div class="container">

                <div class="row">

                    <div class="col-lg-12">

                            <span>Copyright &copy;<script>document.write(new Date().getFullYear());</script> Todos os direitos reservados | Desenvolvido por  <i class="ti-heart" aria-hidden="true"></i>
                            <a href="https://www.rlvconsultoria.com.br" target="_blank" style="color: orange;"><img src="{{url('')}}/transpa/images/RLV_Tecnologia_branca.svg" style="width: 150px; margin-bottom: 3px; margin-left: 5px;"></a></span>

                    </div>

                </div>

            </div>

        </div>

    </footer>

</div>

<!-- FECHA FOOTER -->



<!-- BOTÃO PARA O TOP -->

<button onclick="topFunction()" id="myBtn" title="Go to top">&uarr;</button>

<!-- FECHA BOTÃO PARA O TOP -->

    <div vw class="enabled">
        <div vw-access-button class="active"></div>
        <div vw-plugin-wrapper>
            <div class="vw-plugin-top-wrapper"></div>
        </div>
    </div>
    <script src="https://vlibras.gov.br/app/vlibras-plugin.js"></script>
    <script>
        new window.VLibras.Widget('https://vlibras.gov.br/app');
    </script>


@yield('footer')

</body>

</html>
