
<!doctype html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{$portal->name}} LICITAÇAO DETALHES</title>


    <!-- Facebook -->
    <meta property="og:title" content="{{$portal->name}} LICITAÇÕES">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{asset($portal->imglogo)}}">


    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="{{$portal->name}} LICITAÇÕES">
    <meta name="twitter:image" content="{{asset($portal->imglogo)}}">

    <link rel="shortcut icon" href="http://www.itapemirim.es.leg.br/assets/img/favicon.png">
    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,700' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/bootstrap.min.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/bootflat.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/font-awesome.min.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/fonts.css?v=1.1" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/validationEngine.jquery.min.css" type="text/css">
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/style.css" type="text/css" />
    <link rel="stylesheet" href="{{url('')}}/templates/prefeitura1/licitacao/css/style_controladoria.css?v=2.1" type="text/css">

    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <link href="css/ie10-viewport-bug-workaround.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/html5shiv.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/respond.min.js"></script>
    <![endif]-->

    <!-- Bootstrap -->
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery-1.11.1.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/bootstrap.min.js"></script>
    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/ie10-viewport-bug-workaround.js"></script>

    <!-- Bootflat's JS files.-->
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fs.selecter.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/icheck.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fs.stepper.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.mask.min.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.maxlength.js"></script>
    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/scripts.js?v=2.2"></script>

    <script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.flexisel.js"></script>

    <script type="text/javascript" src="https://www.google.com/jsapi"></script>
    <script>google.load("visualization", "1.1", {packages:["corechart","bar"]});</script>
    <style>
        .pagination .active {
            background-color: {{$portal->headercor}} !important;
        }
    </style>
</head>
<body style="background-color:#fafafa;">


<div class="container-fluid">

<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 paginatransparencia ajustar_fonte" id="pagina">



        <div class="panel panel-primary">
            <div class="panel-heading" style=" background-color: #342b60;">
                <h3 class="panel-title" style="text-transform:uppercase;"> <i class="fa fa-file-text-o"></i>
                    PROCESSO LICITATÓRIO {{$licitacao->nroProcessoLicitatorio}}/{{$licitacao->exercicioLicitacao}}
                </h3>
            </div>

            <div class="panel-body">


                <div role="tabpanel">

                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation">&nbsp;&nbsp;&nbsp;</li>
                        <li role="presentation"  class="active" ><a href="#detalhes" aria-controls="detalhes" role="tab" data-toggle="tab"><i class="fa fa-gavel"></i> DETALHES DA LICITAÇÃO</a></li>



                        <li role="presentation" ><a  href="#vencedores" aria-controls="vencedores" role="tab" data-toggle="tab"><i class="fa fa-trophy"></i> EMPRESA(S) VENCEDORA(S)</a></li>

                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content" style="padding-left:0;padding-right:0;">




                        <div role="tabpanel" class="tab-pane active " id="detalhes" style="min-height:300px">
                            @if($errors->any())
                                <h5 style="color: #00ab6c; text-align: center;">{{$errors->first()}}</h5>
                            @endif
                            <table class="table table-bordered tabelalicitacao">
                                <tbody>
                                <tr>
                                    <td valign="top" class="tdcinza" width="20%">Objeto:</td>
                                    <td colspan="5"> {{$licitacao->Objeto}} </td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">Modalidade:</td>
                                    <td>
                                        @php
                                            $array = [
                                            '0'=>'',
                                            '1'=>'Convite',
                                              '2'=> 'Tomada de Preços',
                                              '3'=> 'Concorrência',
                                              '4'=>   'Concurso',
                                              '5'=>  'Pregão presencial',
                                              '6'=> 'Pregão eletrônico',
                                               '7'=> 'Leilão'
                                            ];

                                        @endphp
                                        {{$array[$licitacao->codModalidadeLicitacao]}}

                                    </td>
                                </tr>
                                <tr>
                                    <td valign="top" class="tdcinza">Nº Modalidade::</td>
                                    <td colspan="5"> {{$licitacao->nroModalidade}}/{{$licitacao->exercicioLicitacao}} </td>
                                </tr>
                                <tr>
                                    <td valign="top" class="tdcinza">Data de Publicação:</td>
                                    <td colspan="5"> {{date('d/m/Y',  strtotime($licitacao->dtPublicacaoEditalDO)) }}</td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">Data da Abertura:</td>
                                    <td>  {{date('d/m/Y',  strtotime($licitacao->dtAbertura)) }}</td>
                                </tr>
                                <tr>
                                    <td class="tdcinza">N&deg; do Processo:</td>
                                    <td>{{$licitacao->nroProcessoLicitatorio}}/{{$licitacao->exercicioLicitacao}}</td>
                                </tr>




                                </tbody>
                            </table>
                        </div><!-- detalhes -->






                        <div  role="tabpanel" class="tab-pane " id="vencedores" style="min-height:300px">
                            <table class="table  table-striped tabelalicitacao">

                                <thead>
                                <tr>
                                    <th scope="col">Código</th>
                                    <th scope="col">Descrição</th>
                                    <th scope="col">Unidade</th>
                                    <th scope="col">V. Unitário</th>
                                    <th scope="col">Qtde</th>
                                    <th scope="col">V. Total</th>
                                    <th scope="col">Empresa Vencedora</th>
                                </tr>
                                </thead>
                                <tbody>

                                @php  $homologacao = DB::connection('another')->table($accont.'_transparencia_homolics')

                ->where('tipoRegistro','10')
                ->where('nroProcessoLicitatorio',$licitacao->nroProcessoLicitatorio)
                ->where('exercicioLicitacao',$licitacao->exercicioLicitacao)
                ->where('account_id',$portal->id)
                ->get();



    function formatCnpjCpf($value)
{
  $cnpj_cpf = preg_replace("/\D/", '', $value);

  if (strlen($cnpj_cpf) === 11) {
    return preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "\$1.\$2.\$3-\$4", $cnpj_cpf);
  }

  return preg_replace("/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/", "\$1.\$2.\$3/\$4-\$5", $cnpj_cpf);
}

                                @endphp
@foreach($homologacao as $i)

    @php
        $item =  DB::connection('another')->table($accont.'_transparencia_items')

  ->where('tipoRegistro','10')
  ->where('codItem',$i->codItem)

  ->where('account_id',$portal->id)
  ->first();

$vtotal = intval($i->vlUnitarioHomologado) * intval($i->Quantidade);


                    $pessoa = DB::connection('another')->table('transparencia_pessoas')->where('nroDocumento',$i->nroDocumento)->where('account_id',$portal->id)->first();


            @endphp



                                <tr>
                                    <th scope="row">{{$i->codItem}}</th>
                                    <td>@if(isset($item)){{$item->dscItem}}@endif</td>
                                    <td>@if(isset($item)){{$item->unidadeMedida}}@endif</td>
                                    <td>R$ {{number_format(intval($i->vlUnitarioHomologado),2,",",".")}}</td>


                                    <td>{{intval($i->Quantidade)}}</td>
                                    <td>R$ {{number_format($vtotal,2,",",".")}}</td>
                                    <td>@if(isset($pessoa)) {{$pessoa->nomeRazaoSocial}} @else{{formatCnpjCpf($i->nroDocumento)}} @endif</td>

                                </tr>
@endforeach
                                </tbody>
                            </table>
                        </div><!-- vencedores -->












                    </div>

                </div>


            </div>


        </div><!-- /panel -->







<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.validationEngine-pt_BR.min.js"></script>
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.validationEngine.min.js"></script>
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/other-validations.js"></script>
<script type="text/javascript">
    $(function(){
        $('.validation').validationEngine({autoHidePrompt:true,promptPosition:"topLeft",scroll:false});
    });

    $(window).load(function() {
        $("#flexiselSlide").flexisel({visibleItems:6,clone:true,pauseOnHover:true,autoPlay:true,animationSpeed:200,autoPlaySpeed: 3000});
    });
</script>



<script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fancybox.js"></script>
<link href="{{url('')}}/templates/prefeitura1/licitacao/css/jquery.fancybox.css" rel="stylesheet">
<script type="text/javascript">
    $(function(){
        $('.fancybox').fancybox();
        $(".popup").fancybox({'width':'95%','height':'90%','autoScale':false,
            'transitionIn':'none','transitionOut':'none','type':'iframe'});

        $(".open_modal_large").fancybox({'width':'98%','height':'90%','autoScale':false,
            'transitionIn':'none','transitionOut':'none','type':'iframe'});
        $(".open_modal_small").fancybox({'width':'50%','height':'90%','autoScale':false,
            'transitionIn':'none','transitionOut':'none','type':'iframe'});

        $('#news_icon').hover(function(){
            $(this).stop(true,true).animate({'right':'0px'}, 'fast');
        }, function(){
            $(this).stop(true,true).animate({'right':'-130px'}, 'fast');
        });


        $('#btn_mobile').on('click', function(){
            $('#menubar, .asidebar, #top-menubar').stop(true,true).slideToggle();
        });
    });


</script>



<link href="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.smartmenus.bootstrap.css" rel="stylesheet">
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.smartmenus.js"></script>
<script type="text/javascript" src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.smartmenus.bootstrap.js"></script>

    </div>
</div>
</div>
</body>
</html>