
@extends('templates.prefeitura3.layout2')
@section('header')
    <!-- You can use Open Graph tags to customize link previews.
Learn more: https://developers.facebook.com/docs/sharing/webmasters -->
    <meta property="og:url"           content="{{url('noticia/'.$pages->url) }}" />
    <meta property="og:type"          content="website" />
    <meta property="og:title"         content="{{$account->name}} - {{$pages->titulo}}" />
    <meta property="og:description"   content="{{$pages->titulo}}" />
    <meta property="og:image"         content="{{ asset($pages->img)}}" />

@endsection
@section('content')
<style>
    .card { border: none!important;}
    .bg_img_noti{
        background-image: url("{{ asset($pages->img)}}");
        background-repeat: no-repeat;
        height: 250px;
        border-radius: 10px;
        background-size: cover;
        background-position-y: 30%;
    }
    @media (max-width: 850px) {
        .carousel-control-next {
            margin-right: -50px;
        }

        .carousel-control-prev {
            margin-left: -50px;

        }
    }
    @media (max-width: 768px) {
        .carousel-inner .carousel-item > div {
            display: none;
        }
        .carousel-inner .carousel-item > div:first-child {
            display: block;
        }
        .carousel-control-next{
            margin-right: 0px;
        }
        .carousel-control-prev{
            margin-left: 0px;
        }
    }

    .carousel-inner .carousel-item.active,
    .carousel-inner .carousel-item-next,
    .carousel-inner .carousel-item-prev {
        display: flex;
    }

    /* display 3 */
    @media (min-width: 768px) {

        .carousel-inner .carousel-item-right.active,
        .carousel-inner .carousel-item-next {
            transform: translateX(25%);
        }

        .carousel-inner .carousel-item-left.active,
        .carousel-inner .carousel-item-prev {
            transform: translateX(25%);
        }
        .carousel-control-next{
            margin-right: -100px;
        }
        .carousel-control-prev{
            margin-left: -100px;
        }
    }

    .carousel-inner .carousel-item-right,
    .carousel-inner .carousel-item-left{
        transform: translateX(0);
    }


</style>

<div style="background-color: #F9F9F9; padding-top: 20px; padding-bottom: 30px;">

    <!-- Go to www.addthis.com/dashboard to customize your tools --> <script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-5d07bdd9c4486a88"></script>
    <div class="container" >
        <div class="row" style="margin-top: 30px;">
            <div class="col-md-4">
            <div class="  titulonoticia" style="width: 60%; right: 0%; position: absolute; left: 0%;padding-top:10px; top: 10%; text-align: left; margin-left: 30px; padding-bottom:10px;">

                <a class="btn btn-default" style="  border-radius: 15px;  background-color: #FFF;
                                             z-index: 10000!important; color: black; padding-top:1px; padding-bottom:1px; margin-bottom: 10px; ">{{App\Category::find($pages->category_id)->name}}</a>

                <a href="{{routeTenant('site.noticias',[$pages->url])}}" style="z-index: 10000!important; margin-top: 60px;"> <h3 style="color: #000; margin-top: 30px;">{{$pages->titulo}}</h3></a>

            </div>
            </div>
            <div class="col-md-8 bg_img_noti">


            </div>
        <div class="row"   style="margin-top: 20px;">
            <div class="col-md-8 ">




                <div style=" padding: 30px; border-top: 2px #EBEBEB solid;">
                    <div style="padding-bottom: 10px;">   <i class="fa fa-clock-o" style="color: #000;" aria-hidden="true"></i>  <span style="color: #000; font-weight: bold;">{{ date('d/m/Y' ,strtotime($pages->created_at))}}</span></div>


                    {!! $pages->conteudo !!}

{{--                    <h4>Compatilhe:</h4>--}}
{{--                    <!-- Go to www.addthis.com/dashboard to customize your tools --> <div class="addthis_inline_share_toolbox"></div>--}}
                </div>




            </div>

            <div class="col-md-4 " >
                <h5  style="color: #646464; font-size: 17px; margin-top: 12px; margin-bottom: 10px; ">Mais lidas</h5>
                <div style="background-color: #FFF; padding: 10px;">
                @foreach($noticia2s as $noticia)
                    <div class="row" >
                        <div class="col-md-5"style="">

                            <div class="img-canvas" style="  ">
                                <a href="{{url('noticia/'.$noticia->url) }}">
                                    <img src="{{asset($noticia->img)}}" class="img-thumbnail"
                                         alt="{{$noticia->titulo}}" title="{{$noticia->titulo}} ">
                                </a>
                            </div>
                        </div>
                        <div class="col-md-7"style=" text-align: justify;">
                            <span class="title_noticia2">{{App\Category::find($noticia->category_id)->name}}</span>   <span style="color: #ADADAD; border-left:#ADADAD solid 2px; padding-left: 10px;  font-size: 12px;"><i class="fa fa-clock-o" aria-hidden="true"></i> {{$noticia->created_at->format('d/m/Y')}}</span>
                            <a href="{{url('noticia/'.$noticia->url) }}"> <h3 style="font-size: 16px; color: black; padding: 10px 20px 10px 20px; font-weight: bold;">{{$noticia->titulo}}</h3> </a>

                        </div>
                    </div>
                    <hr>
                @endforeach
                </div>
                <h5  style="color: #646464; font-size: 14px; margin-top: 12px; margin-bottom: 10px; ">Compartilhe esta notícia</h5>
                <a class="bc-share-def bc-fb2" href="https://www.facebook.com/sharer/sharer.php?u={{url('noticia/'.$pages->url) }}"
                   id="bc-fb" rel="nofollow" target="_blank"><i class="fa fa-facebook" aria-hidden="true" style="color: var(--backgroud-header); font-size: 30px;"></i></a>

                <a class="bc-share-def bc-tw2" style="color: var(--backgroud-header); font-size: 30px; margin-left: 15px;"
                   href="https://twitter.com/intent/tweet?url={{url('noticia/'.$pages->url) }}&amp;text={{rawurlencode ( $pages->titulo) }}&amp;via=Cyberini" id="bc-tw" rel="nofollow" target="_blank"><i class="fa fa-twitter" aria-hidden="true"></i></a>
            </div>


        </div>



    </div>
    </div>
    @if(count(\App\ImagemNoticia::where('noticia_id',$pages->id)->get() ) != 0)
    <div class="container text-center my-3" style="margin-top: 30px; border-top: 2px solid #EBEBEB; padding-top: 30px; padding-bottom: 60px;" >
        <div class="row mx-auto my-auto">
            <div id="recipeCarousel" class="carousel slide w-100" data-ride="carousel">
                <div class="carousel-inner w-100" role="listbox">

@php $co = 0; @endphp
                    @foreach(\App\ImagemNoticia::where('noticia_id',$pages->id)->get() as $d)
                    <div class="carousel-item @if($co == 0 )active @endif">
                        <div class="col-md-3">
                            <div class="card card-body" style="padding: 0;">
                                <img class="img-fluid" src="{{asset($d->url)}}">
                            </div>
                        </div>
                    </div>
                        @php $co++; @endphp
                    @endforeach



                </div>
                <a class="carousel-control-prev w-auto" href="#recipeCarousel" role="button" data-slide="prev" style="font-size: 30px;  color: var(--backgroud-header);">
                   <i class="fa fa-arrow-circle-left" aria-hidden="true"></i>
                    <span class="sr-only">Previous</span>
                </a>
                <a class="carousel-control-next w-auto" href="#recipeCarousel" role="button" data-slide="next" style="font-size: 30px;  color: var(--backgroud-header);">
                    <i class="fa fa-arrow-circle-right" aria-hidden="true"></i>
                    <span class="sr-only">Next</span>
                </a>
            </div>
        </div>
    </div>
    @endif

    <div class="container" >
    <div class="row" style="padding: 20px; background-color: #FFF; ">
        <div class="col-md-12">
            <div class="fb-comments" data-href="{{url('noticia/'.$pages->url) }}" data-width="100%" data-numposts="10"></div>
        </div>
    </div>

    <div class="row" style="margin-top: 30px;">
        <div class="col-md-12" style="margin-bottom: 10px;"><h6 style="color: #646464;">Últimas notícias</h6></div>
    </div>
    <div class="row" style="background-color: #FFFFFF; padding: 20px;">
        @php $cont = 1; @endphp
        @foreach($noticia3s as $noticia)
            <div class="col-md-3" style="@if($cont < count($noticia3s) ) border-right: 2px solid #EBEBEB; @endif">
                <div class="card" style="width: 80%; margin-left: 10%;">
                    <a href="{{routeTenant('site.noticias',[$noticia->url])}}" >
                        <img class="card-img-top" src="{{asset($noticia->img)}}" alt="Card image cap">
                    </a>
                    <div class="card-body">
                        <h6 class="card-title" style="color: var(--backgroud-header);">{{App\Category::find($noticia->category_id)->name}}</h6>
                        <a href="{{routeTenant('site.noticias',[$noticia->url])}}" >
                            <p class="card-text" style="color: #000; font-weight: bold;">{{$noticia->titulo}}</p>
                        </a>
                        <span style="color: #ADADAD; font-size: 13px;">{{$noticia->created_at->format('d/m/Y')}}</span>
                    </div>
                </div>
            </div>
            @php $cont++; @endphp
        @endforeach

    </div>
    </div>
    </div>



<div id="fb-root"></div>
<script async defer crossorigin="anonymous" src="https://connect.facebook.net/pt_BR/sdk.js#xfbml=1&version=v10.0" nonce="TF1mnNNM"></script>

@endsection



@section('post-script')
    <script>
        $('#recipeCarousel').carousel({
            interval: 10000
        })

        $('.carousel .carousel-item').each(function(){
            var minPerSlide = 1;
            var next = $(this).next();
            if (!next.length) {
                next = $(this).siblings(':first');
            }
            next.children(':first-child').clone().appendTo($(this));

            for (var i=0;i<minPerSlide;i++) {
                next=next.next();
                if (!next.length) {
                    next = $(this).siblings(':first');
                }

                next.children(':first-child').clone().appendTo($(this));
            }
        });
    </script>


@endsection
